<?php
if (isset($public) || isset($semRefrescamento)) {
	include_once '../modelo/filiado.modelo.php';
	include_once '../controlador/venda.controlador.php';
}else {
	include_once 'modelo/filiado.modelo.php';
	include_once 'controlador/venda.controlador.php';
}
 
 
class ControladorFiliado 
{
 
static public function ctrAddFiliado()
{
 	
	if (!empty($_SESSION["idVagaFiliado"])) 
	{
				$idVaga = addslashes($_SESSION["idVagaFiliado"]);
				$dataCadastro = addslashes(date("d-m-Y H:i:s"));
				$idUsuario = addslashes($_SESSION['ID_usuario']);

				$dados = array("idVaga" => filter_var($idVaga,FILTER_SANITIZE_STRIPPED), 
				"dataCadastro" => filter_var($dataCadastro,FILTER_SANITIZE_STRIPPED),
				"idUsuario" => filter_var($idUsuario,FILTER_SANITIZE_STRIPPED));
 
				$verifExistencia = ControladorFiliado::ctrVerificarSeOUsuarioJaEstaFiliadoAVaga($idVaga, $idUsuario);
				if ($verifExistencia == true) 
				{ 
					$Vaga = ModeloFiliado::mdlAddFiliado($dados);

					if($Vaga == "ok"){ 
							echo"
					<script>
					Swal.fire({
						position: 'top-end',
						icon: 'success',
						title: 'Você foi filiado com sucesso!',
						showConfirmButton: false,
						timer: 5000
					})
					</script>
					";	
					}else{ 
						echo"
						<script>
							Swal.fire({
								position: 'top-end',
								icon: 'error',
								title: 'Erro:  Não foi possivel filiar-te a este produto',
								showConfirmButton: false,
								timer: 5000
							})
						</script>";
						
					}
				 }else
				{
					echo"
					<script>
							Swal.fire({
								position: 'top-end',
								icon: 'error',
								title: 'Erro: Você já esta filiado a este produto',
								showConfirmButton: false,
								timer: 5000
							})
					</script>
					";
				} 

	}
			else{
				echo"
					<script>
							Swal.fire({
								position: 'top-end',
								icon: 'error',
								title: 'Erro: Preencha os campos obrigatorios',
								showConfirmButton: false,
								timer: 5000
							})
					</script>
				";	
			}
}


static public function ctrVerificarSeOUsuarioJaEstaFiliadoAVaga($idVaga, $idUsuario){

	$Vaga = ModeloFiliado::mdlMostrarFiliadoPoridVagaEIdUsuario($idVaga, $idUsuario);
	if (empty($Vaga)) {
		return true;
	}
	else {
		return false;
	}
}
 
   
static public function ctrMostrarTodasVagas(){ 

	$Vaga = ModeloVaga::mdlMostrarTodasVagas();
	return $Vaga;
	
}
 
static public function ctrMostrarFiliadoPorIdFiliado($idFiliado){
	$Vaga = ModeloFiliado::mdlMostrarFiliadoPorIdFiliado($idFiliado);
	return $Vaga;
}

static public function ctrMostrarVagasQueUsuarioEstaFiliadoPorIdUsuario($idUsuario){
	$Vaga = ModeloFiliado::mdlMostrarVagasQueUsuarioEstaFiliadoPorIdUsuario($idUsuario);
	return $Vaga;
}

static public function ctrMostrarQuantoCursoSouAfiliadoPorIdUsuario($idUsuario){
	
	$filido = ControladorFiliado::ctrMostrarVagasQueUsuarioEstaFiliadoPorIdUsuario($idUsuario);
        
	return count($filido);
}

static public function ctrMostrarQuantoGanhouComVendasComoFiliadoPorIdUsuario($idUsuario){
	$total = 0;
	$filido = ControladorFiliado::ctrMostrarVagasQueUsuarioEstaFiliadoPorIdUsuario($idUsuario);
        foreach ($filido as $key => $valorFiliado) {
            $venda = ControladorVenda::ctrMostrarTodasVendasDoAfiliadoPorIdFiliado($valorFiliado['idFiliado']);
            foreach ($venda as $indice => $infoVenda) {
				$total += $infoVenda["cumissaoFiliado"];
			}
		}
	return $total;
}

static public function ctrMostrarFiliadoPorIdVaga($idVaga){
	$Vaga = ModeloFiliado::mdlMostrarFiliadoPorIdVaga($idVaga);
	return $Vaga;
}

static public function ctrContarTotalDeCursoQueTenhoNaPlataforma($idRecrutador){
	$Vaga = ModeloVaga::mdlMostrarMinhasVagasPorIdUsurario($idRecrutador);
	return count($Vaga);
}

static public function ctrContarSectoresComVagasDisponivel(){
	$Vaga = ModeloVaga::mdlMostrarVagasDisponivel();
	return count($Vaga);
}

static public function ctrContarVagasDisponivel(){
	$quantVaga = 0;
	$Vaga = ModeloVaga::mdlMostrarVagasDisponivel();
	foreach ($Vaga as $key => $value) {
		$quantVaga = $quantVaga + $value["quantidadeVagasDisponivel"];
	}
	return $quantVaga;
}

static public function ctrMostrarVagaPeloNomeDaVagaEPeloIdUsurario($vaga, $idRecrutador){

		$Vaga = ModeloVaga::mdlMostrarVagaPeloNomeDaVagaEPeloIdUsurario($vaga, $idRecrutador);

		return $Vaga;

	}

	static public function ctrEditarPrecoDoCertificadoPorIdVaga($idVaga, $precoCertificado){

		$Vaga = ModeloVaga::mdlEditarPrecoDoCertificadoPorIdVaga($idVaga, $precoCertificado);

		return $Vaga;

	}

	static public function ctrEditarModeloDoCertificadoPorIdVaga($idVaga, $idModeloCertificado){

		$Vaga = ModeloVaga::mdlEditarModeloDoCertificadoPorIdVaga($idVaga, $idModeloCertificado);

		return $Vaga;

	}
 
	static public function ctrActualizarDadosUsuarioprofessors($nome, $bi_nif, $nivelDeAcesso, $id){  

		$Vaga = ModeloUsuario::mdlActualizarDadosUsuarioprofessors(addslashes($nome), addslashes($bi_nif), addslashes($nivelDeAcesso),addslashes($id));

		return $Vaga;

	}

	static public function ctrActualizarImagemPerfilUsuario($imagem,$id){

		$Vaga = ModeloUsuario::mdlActualizarImagemPerfilUsuario($imagem,addslashes($id));

		return $Vaga;

	}

	static public function ctrActualizarCodigoParaReporSenha($idUsuario, $codigo){

		$Vaga = ModeloUsuario::mdlActualizarCodigoParaReporSenha($idUsuario, $codigo);
		return $Vaga;

	}
 
	static public function ctrActualizarSenhaUsuario($senhaAntiga,$id, $senha){

		$Vaga = ModeloUsuario::mdlActualizarSenhaUsuario(addslashes($senhaAntiga),addslashes($id), md5(addslashes($senha)));
		return $Vaga;

	}

	static public function ctrActualizarReporSenhaUsuario($senha,$id,$codigoParaReporSenha){

		$Vaga = ModeloUsuario::mdlActualizarReporSenhaUsuario(md5(addslashes($senha)),$id,$codigoParaReporSenha);
		return $Vaga;

	}

	static public function ctrDeletarUsuario($id){

		$Vaga = ModeloUsuario::mdlDeletarUsuario(addslashes($id));
		return $Vaga;

	}

}

?>